# BONELAB Fusion
Having been in development for 5 months, the long awaited multiplayer mod FUSION for BONELAB is here.<br>

![](https://i.imgur.com/1ZpMfei.png)

# Installation
You can find the latest installation guide [here](https://github.com/Lakatrazz/BONELAB-Fusion/wiki#installation).

# About
## How to Use the Mod
You can access the Fusion menu by clicking on the "Fusion" button in the Preferences menu.

If you did not already install the [Fusion Content](https://mod.io/g/bonelab/m/fusion-content), clicking this will install it.
It will only install correctly if you are logged into mod.io in VoidG114 or BONELAB Hub, so make sure this is the case.

## Physical Interactions
Instead of players and synced props being kinematic, non-physics objects, all interactions are solved using physical forces.<br>
This means you can pick up your friends, throw them, stand on them, push them, and more.

## Campaign Support
The entire campaign has been ensured completable, with nearly every custom event synced, as well as optimizations made to make the experience run as smoothly as possible.

## Supported Platforms
- Steam PCVR
- Meta PCVR
- Meta Quest

## Crossplay Support
All platforms are able to crossplay together. In order to do so, you must log in to the same Networking Layer upon opening the menu.<br>
Note that the Meta Quest platform has "Proxy" versions of the PCVR layers, but they will connect to each other just fine.

# Additional Content
## Modules, Gamemodes, and the Bitmart
Fusion has integrated support to allow other mods to implement Fusion compatibility using "Modules". There is an SDK for Unity, allowing you to implement features while in multiplayer, as well as a code SDK in order to create unique synced features. You can find both of these [here](https://github.com/Lakatrazz/BONELAB-Fusion).

Besides that, Fusion also has integrated gamemodes. The current gamemodes are:
- Deathmatch, Free-for-all fighting!
- Team Deathmatch, Kill as many players on the opposite team!
- Entangled, Be constrained to a randomized partner!
- Hide and Seek, Seekers try to find hiders as quick as possible!
- Smash Bones, use dropped items to knock players off the stage and be the last one standing!
- Juggernaut, defeat the giant Juggernaut to gain its power, then kill as many survivors as possible!

Custom maps can implement these gamemodes, and customize them specifically for their map.

Finally, Fusion has built in cosmetics. Winning gamemodes will earn you Bits to use at the Bitmart. Here, you are able to equip/unequip as well as purchase items such as cosmetics. Other players will be able to see these cosmetics, and you can mix and match as you choose.

## Achievements
As an additional way to earn Bits, you can accomplish various tasks to complete Achievements. There are a large amount of Achievements, each with differing challenge, risk, and reward. Upon completing every achievement, you may even unlock some secret items!

# More
## Credits
You can view the most recent changes and credits in the in game info box in VoidG114.

## Source
- Fusion: https://github.com/Lakatrazz/BONELAB-Fusion
- Fusion Helper: https://github.com/Lakatrazz/Fusion-Helper

## Soundtrack
You can listen to the Fusion official soundtrack here:

[![Soundtrack](https://i.imgur.com/ppUtaMd.png)](https://www.youtube.com/playlist?list=PLNifPIaAecBKTMlKSBYfeW81UZgNNfYe0)

## Footage

[![Launch Trailer](https://i.imgur.com/9qAdvsc.png)](https://www.youtube.com/watch?v=pVavphtfTd4)